<?php

use App\Http\Controllers\GenreController;
use App\Http\Controllers\SubGenreController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ArtistController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\DspController;
use App\Http\Controllers\UserdspController;
use App\Http\Controllers\SublabelController;
use App\Http\Controllers\LabelController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\UPCSController;
use App\Http\Controllers\ReleaseController;

Auth::routes();
Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::resources([
    'roles' => RoleController::class,
    'users' => UserController::class,
    'genre' => GenreController::class,
    'subgenre' => SubGenreController::class,
    'artists' => ArtistController::class,
    'country' => CountryController::class,
    'dsp' => DspController::class,
    'userdsp' => UserdspController::class,
    'sublabel' => SublabelController::class,
    'upcs' => UPCSController::class,
    'release' => ReleaseController::class,
    'label' => LabelController::class
]);

Route::post('/genre/status/update', [GenreController::class, 'statusUpdate'])->name('genre.status.update');
Route::post('/subgenre/status/update', [SubGenreController::class, 'statusUpdate'])->name('subgenre.status.update');
Route::post('/country/status/update', [CountryController::class, 'statusUpdate'])->name('country.status.update');
Route::post('/userdsp/status', [UserdspController::class, 'userDspStatus'])->name('userdsp.userDspStatus');
Route::post('/dsp/status/update', [DspController::class, 'statusUpdate'])->name('dsp.status.update');
Route::post('/upcs/manual/upload', [UPCSController::class, 'manualUpload'])->name('upcs.manual.upload');


/**
 * 
 * Release routes
 * 
 */
Route::post('/release/subgenre', [ReleaseController::class, 'getReleaseSubGenre'])->name('release.subgenre');
Route::post('/release/track/save/{id}', [ReleaseController::class, 'releaseTrackUpdate'])->name('release.track.save');
Route::post('/release/multiple/track/save/{id}', [ReleaseController::class, 'releaseMultipleTrackUpdate'])->name('release.multiple.track.save');
Route::post('/release/terriory/save/{id}', [ReleaseController::class, 'releaseTerrioryUpdate'])->name('release.terriory.save');
Route::post('/release/delivery/save/{id}', [ReleaseController::class, 'releaseDeliveryUpdate'])->name('release.delivery.save');
Route::post('/release/finish/save/{id}', [ReleaseController::class, 'releaseFinishUpdate'])->name('release.finish.save');
Route::post('/release/labels/save', [ReleaseController::class, 'releaseLabelsSave'])->name('release.labels.save');
Route::get('/release/labels/delete', [ReleaseController::class, 'releaseLabelsDelete'])->name('release.labels.delete');
Route::post('/release/getsublabels', [ReleaseController::class, 'getReleaseSubLabelsofLabels'])->name('release.getsublabels.oflables');
Route::post('/release/upload/single/lyrics', [ReleaseController::class, 'uploadReleaseSingleLyrics'])->name('upload.release.single.lyrics');
Route::post('/release/artist/create', [ReleaseController::class, 'releaseArtistCreate'])->name('release.artist.create');
Route::post('/release/track/delete', [ReleaseController::class, 'releaseTrackDelete'])->name('release.track.delete');
Route::post('/release/track/edit', [ReleaseController::class, 'releaseTrackEdit'])->name('release.track.edit');
Route::post('/release/track/edit/modal/{id}', [ReleaseController::class, 'releaseTrackUpdateModals'])->name('release.track.edit.modal');